/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.lighting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.lighting.FlatQuadLighter;
import net.neoforged.neoforge.client.model.lighting.QuadLighter;
import net.neoforged.neoforge.client.model.lighting.SmoothQuadLighter;
import net.neoforged.neoforge.common.NeoForgeConfig;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LightPipelineAwareModelBlockRenderer
extends ModelBlockRenderer {
    private static final Direction[] SIDES = Direction.values();
    private final ThreadLocal<QuadLighter> flatLighter = ThreadLocal.withInitial(() -> new FlatQuadLighter(colors));
    private final ThreadLocal<QuadLighter> smoothLighter = ThreadLocal.withInitial(() -> new SmoothQuadLighter(colors));

    public LightPipelineAwareModelBlockRenderer(BlockColors colors) {
        super(colors);
    }

    public void tesselateWithoutAO(BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean checkSides, RandomSource rand, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        if (((Boolean)NeoForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            LightPipelineAwareModelBlockRenderer.render(vertexConsumer, this.flatLighter.get(), level, model, state, pos, poseStack, checkSides, rand, seed, packedOverlay, modelData, renderType);
        } else {
            super.tesselateWithoutAO(level, model, state, pos, poseStack, vertexConsumer, checkSides, rand, seed, packedOverlay, modelData, renderType);
        }
    }

    public void tesselateWithAO(BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean checkSides, RandomSource rand, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        if (((Boolean)NeoForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            LightPipelineAwareModelBlockRenderer.render(vertexConsumer, this.smoothLighter.get(), level, model, state, pos, poseStack, checkSides, rand, seed, packedOverlay, modelData, renderType);
        } else {
            super.tesselateWithAO(level, model, state, pos, poseStack, vertexConsumer, checkSides, rand, seed, packedOverlay, modelData, renderType);
        }
    }

    public static boolean render(VertexConsumer vertexConsumer, QuadLighter lighter, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, boolean checkSides, RandomSource rand, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        LightPipelineAwareModelBlockRenderer renderer = (LightPipelineAwareModelBlockRenderer)Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        PoseStack.Pose pose = poseStack.last();
        boolean empty = true;
        boolean smoothLighter = lighter instanceof SmoothQuadLighter;
        QuadLighter flatLighter = null;
        rand.setSeed(seed);
        List quads = model.getQuads(state, null, rand, modelData, renderType);
        if (!quads.isEmpty()) {
            empty = false;
            lighter.setup(level, pos, state);
            for (BakedQuad quad : quads) {
                if (smoothLighter && !quad.hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = renderer.flatLighter.get();
                        flatLighter.setup(level, pos, state);
                    }
                    flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                    continue;
                }
                lighter.process(vertexConsumer, pose, quad, packedOverlay);
            }
        }
        for (Direction side : SIDES) {
            if (checkSides && !Block.shouldRenderFace((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)side, (BlockPos)pos.relative(side))) continue;
            rand.setSeed(seed);
            quads = model.getQuads(state, side, rand, modelData, renderType);
            if (quads.isEmpty()) continue;
            if (empty) {
                empty = false;
                lighter.setup(level, pos, state);
            }
            for (BakedQuad quad : quads) {
                if (smoothLighter && !quad.hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = renderer.flatLighter.get();
                        flatLighter.setup(level, pos, state);
                    }
                    flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                    continue;
                }
                lighter.process(vertexConsumer, pose, quad, packedOverlay);
            }
        }
        lighter.reset();
        if (flatLighter != null) {
            flatLighter.reset();
        }
        return !empty;
    }

    public QuadLighter getQuadLighter(boolean smooth) {
        return (smooth ? this.smoothLighter : this.flatLighter).get();
    }
}

